clc
clear 
close all

name = {'elev', 'srad', 'tavg', 'tmax', 'tmin', 'vapr', 'wind'}; % print the name of the folder
folder = cellfun(@(p) addpath(strrep("wc2.1_30s_%PARAM%", "%PARAM%", p)), name, 'UniformOutput', false);

months = sprintfc('%02d', 12); % print the # of months

c = 43200/2;

% maximum temperature
Tmax = readgeoraster(strrep("wc2.1_30s_tmax\wc2.1_30s_tmax_%m%.tif", "%m%", months));
Tmax(Tmax == (min(Tmax, [], "all"))) = NaN;

disp("Maximium temperature")

% minimum temperature
Tmin = readgeoraster(strrep("wc2.1_30s_tmin\wc2.1_30s_tmin_%m%.tif", "%m%", months));
Tmin(Tmin == (min(Tmin, [], "all"))) = NaN;

disp("Minimum temperature")

% water vapour pressure
vapr = readgeoraster(strrep("wc2.1_30s_vapr\wc2.1_30s_vapr_%m%.tif", "%m%", months));
vapr(vapr == (min(vapr, [], "all"))) = NaN;

disp("Water vapour pressure")

%% Calculation of delta and VPD
% group 1:
% Tmax = Tmax(:, 1:c);
% Tmin = Tmin(:, 1:c);
% vapr = vapr(:, 1:c);

% group 2:
Tmax = Tmax(:, c+1:end);
Tmin = Tmin(:, c+1:end);
vapr = vapr(:, c+1:end);

% water vapour pressure at saturation, measured in [kPa]
es_max = 0.6108 * exp((17.27 * Tmax) ./ (Tmax + 237.3)); % 237.3 è espressa in °C
es_min = 0.6108 * exp((17.27 * Tmin) ./ (Tmin + 237.3)); % quindi T deve essere in °C

es = (es_max + es_min) ./ 2; % corrisponde a es*

disp("es")

% slope of the Clausius Clapeyron curve, measured in [kPa/°C]
delta_max = (4098 * es_max) ./ ((Tmax + 237.3).^2); % 237.3 è espressa in °C
delta_min = (4098 * es_min) ./ ((Tmin + 237.3).^2); % quindi T deve essere in °C

delta = (delta_max + delta_min) ./ 2;

disp("delta")

% air vapour pressure deficit, measured in [kPa]
VPD = es - vapr;

disp("VPD")

disp("Saving delta and VPD...")

save(strrep("delta2_%m%.mat", "%m%", months), "delta", "-v7.3");
save(strrep("VPD2_%m%.mat", "%m%", months), "VPD", "-v7.3");

%% Putting together the results

delta1 = load(strrep("delta1_%m%.mat", "%m%", months));
delta2 = load(strrep("delta2_%m%.mat", "%m%", months));

delta1 = delta1.delta;
delta2 = delta2.delta;
delta_tog = [delta1 delta2];

disp("Saving delta together...")

save(strrep("delta_%m%.mat", "%m%", months), "delta_tog", "-v7.3");


VPD1 = load(strrep("VPD1_%m%.mat", "%m%", months));
VPD2 = load(strrep("VPD2_%m%.mat", "%m%", months));

VPD1 = VPD1.VPD;
VPD2 = VPD2.VPD;
VPD_tog = [VPD1 VPD2];

disp("Saving VPD together...")

save(strrep("VPD_%m%.mat", "%m%", months), "VPD_tog", "-v7.3");